/****** Object:  Table [dbo].[Response]    Script Date: 2020-07-07 1:35:43 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF OBJECT_ID('dbo.Recording', 'U') IS NOT NULL
DROP TABLE [dbo].[Recording]
GO


CREATE TABLE [dbo].[Recording](
	[RecordId] [bigint] IDENTITY(1,1) NOT NULL,
	[Respondent] [varchar](10) NOT NULL,
	[rpsQuestion] [nvarchar](32) NOT NULL,
	[rpsMatrix] [bigint] NOT NULL,
	[rpsMention] [int] NOT NULL,
	[CallCount] [int] NOT NULL,
	[RecordDate] [datetime] NOT NULL,
	[Interviewer] [int] NULL, -- Case of IVRmmServer
	[FileName] [nvarchar](256) NOT NULL,
	[TelephonyId] [int] NULL,
	[RealFileName] [nvarchar](256) NULL,
	[Duration] [datetime] NULL,
	[RecordResult] [int] NULL,
 CONSTRAINT [PK_Recording] PRIMARY KEY CLUSTERED 
(
	[RecordId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY],

) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_Interview] ON [dbo].[Recording]
(
	[Respondent] ASC,
	[CallCount] DESC,
	[RecordDate] DESC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO 

ALTER TABLE [dbo].[Recording]  WITH CHECK ADD CONSTRAINT [FK_Recording_Respondent] FOREIGN KEY([Respondent])
REFERENCES [dbo].[Respondent] ([ResRespondent])
ON DELETE CASCADE
GO

ALTER TABLE [dbo].[Recording] CHECK CONSTRAINT [FK_Recording_Respondent]
GO
